up:: [[MOCs Overview]]
tags:: #effort #output/multiple
rank:: 4

- Outputs
	- output:: #output/lesson 2022-02-01 - lesson retired
	- output:: #output/twitter☑️ 2022-07-21 - [twitter thread](https://twitter.com/NickMilo/status/1562063375491817473).
	- output:: #output/youtube☑️ 2022-07-21 - [youtube video](https://www.youtube.com/watch?v=JV_7nppxv7A).
	- output:: #output/newsletter 2022-07-26 - [newsletter](https://ckarchive.com/b/n4uohvh8xw94n).
	- output:: #output/website 2022-xx-xx - website

> [!NOTE]+ Notes on this note
> This is a sanitized version of my actual note. 
> - Some content and links have been removed.

# Sensemaking happens by triangulation
> Triangulation is using two known points to find a third point. 

Every version of sensemaking we do—every moment of every day—involves us triangulating information. 

Triangulation says *I am the ultimate sensemaking mechanism, to both the known and unknown.*

**The three powers of triangulation**
- You can use what you know to make sense of stuff.
	- Use two known points, to better understand a third point.
- You can use what you know to remember old stuff.
	- Use two known points, to remember a forgotten third point.
- You can use what you know to create new stuff.
	- Use two known points to imagine a third point.

### Use two known points, to better understand a third point.
![[feynman-triangulation-1.png]]


### Use two known points, to remember a forgotten third point.
![[feynman-triangulation-2.png]]

### Use two known points to imagine a third point.
![[feynman-triangulation-3.png]]

**The third power of triangulation is basically [[Idea Emergence]]**. 

So how does one improve their triangulation skills? By getting reps connecting ideas. 

One of the best ways is using MOCs to cluster ideas, which will spark connections and spur insights.

---

### Close
- If you prioritize over-collecting, you also prioritize under-thinking.
- If you prioritize rote memorization, you also prioritize rigid thinking.
- If you prioritize highlighting, you also prioritize passive thinking.

Those priorities deprioritize sensemaking, triangulation, and your ability to _understand the interrelationships of nature_.

The better you triangulate, the faster you can move in the world. 

- If you don't over-collect and drown your system in noise...
- If you don't over-structure and suffocate your system in rigidity...
- If you don't over-highlight and leave little time for active thinking...

Then you will have a healthy link-based PKM framework where Idea Emergence can work for you.

You will have an emergent system that strengthens your ability to triangulate "knowledge" and will allow you to:

- Make better sense of things
- Remember past stuff better
- Create new insights more naturally

---
### Outro 

**The three powers of triangulation**
- You can use what you know to make sense of stuff.
	- Use two known points, to better understand a third point.
- You can use what you know to remember old stuff.
	- Use two known points, to remember a forgotten third point.
- You can use what you know to create new stuff.
	- Use two known points to imagine a third point.


---



# Youtube video
> Triangulation is using two known points to find a third point. 

---
Every version of sensemaking we do
—every moment of every day—
involves us triangulating information. 

---

Triangulation says:
*"I am the ultimate sensemaking mechanism, 
to both the known and unknown."*

---
**The three powers of triangulation**
1. Use what you know to make sense of stuff.
2. Use what you know to remember old stuff.
3. Use what you know to create new stuff.

---
**The three powers of triangulation**
1. Use two points, to *understand* a third point.
1. Use two points, to *remember* a third point.
1. Use two points to *imagine* a third point.

---

**The 1st power of triangulation**
Use two points, to *understand* a third point.

---

**The 2nd power of triangulation**
Use two points, to *remember* a third point.
![[feynman-triangulation-1.png]]

---
**The 2nd power of triangulation**
Use two points, to *remember* a third point.
![[feynman-triangulation-2.png]]

---
**The 3rd power of triangulation**
Use two points to *imagine* a third point.

![[feynman-triangulation-3.png]]

---

> The better you triangulate, 
> the faster you can move 
> in the world of ideas.

---

#### If...
- If you don't over-collect and drown your system in noise...
- If you don't over-structure and suffocate your system in rigidity...
- If you don't over-highlight and leave little time for active thinking...

---

#### Then...
You will have an emergent system that encourages your ability to triangulate "knowledge".

---

You will leverage these always-present **powers of triangulation** to *understand*, *remember*, and *imagine* better than ever before.

---

These **three powers of triangulation** underpin everything we cover in the following lessons. 


###### Youtube comments
So the third power is basically Idea Emergence? How does one improve their triangulation skills?

Exactly!!! By getting reps connecting ideas. One of the best ways is using MOCs to cluster ideas, which will spark connections and spur insights.

Erick Wutke 1 day ago
When you put yourself (Nick), as a "mediator" for the concept apprehension, I thought: "wow, this isn't just concept triangulation, it's more: he's got his René Girard on point"

ME: Thank you! Can you elaborate on the René Girard reference? I would love to know how he did things

That is quite a task I'll try. Basically Girard "discovered" another facet of the human nature: that every desire is mimetic, or as the early version of the theory says: that there's a "mimetic triangulation of desire" where the mediator, who possesses the object of desire (with time) is to be hated/envied if he is close to the person who desires (like a friend, parent, etc), or admired if he is far (just like I admire Girard because I want "his" intelligence, theoretic capacity, etc). 

He started observing this in literature, stating that there is a "Romantic Lie" in which the objects are desired for themselves, and a "Novelistic Truth" in which the triangulation is unveiled (Dostoievsky, Shakespeare, Cervantes, Stendhal, Flaubert, Proust... Our Machado de Assis) and then in Anthropology, in the Bible and mythic narratives, always revealing a layer of envy or pursuit depending on the distance of a mediator from the person who desires.

The theory gets more interesting when the object desired and the mediator are the same person, which is what makes us prone into thinking that love, for example, is a linear thing (the Romantic Lie). But the triangular dynamic is still kept the same: you can strive to achieve the very same thing that you develop resentment towards to in the process. Or in the case of Narcissus, where he himself occupies the three points of the triangle! 

The theory also adds some interesting layers to the Freudian "Totem and Taboo" archetype of the origin of societal violence and subsequent legislation and mitigation of violence, too. There's a temptation to try and explain every event of escape-goating and society violence as the multiplication of interconnected close triangules that scales up. 

But some commentators note that could not explain the genocides of the 20th century as it can explain the escape-goating of Jesus and other figures in much smaller scale. So... going back to the video, you're definitely not wrong in noting that for us to apprehend something, to "take hold of it", we need to get it through someone who already "owns" it, and to bring one closer, is to bring the other too - to a point =P

ME: Whoa. You are correct about the size of the task I was requesting, but I'm grateful you've enlightened me on this angle of the topic!

# Tweet thread
Here's the link to the finished version on Twitter: [https://twitter.com/NickMilo/status/1562063375491817473](https://twitter.com/NickMilo/status/1562063375491817473).

People complain about Obsidian graphs, but they're forgetting its most powerful purpose... TRIANGULATION! Here's how you can use it to unlock new insights in your PKM 👇


What is "triangulation?" Triangulation is how we make sense of the world. We do it all the time! It's using two "known points" to find a third "unknown point." Triangulation helps you: 1. UNDERSTAND 2. REMEMBER 3. & IMAGINE Now let me show you how they work...


The 1st Power of Triangulation: UNDERSTAND 📐 
Use what you know to understand what you don't! For example, here are 3 (very simple) points: • you (known) • me (known) • idea (unknown) Your goal: Understand this idea → "Pace Layers"


If you don't know me... or the idea... you can't make a nice triangle. So you won't understand! If you know me better... you can use me as an anchor point to better understand Pace Layers. When you are clear on two points, you can better understand the third point.


We do this countless times a day! We triangulate to understand how things we *know* relate to things we *don't know.* Once you have a bunch of dots on your Map, you can UNDERSTAND things rapidly. But how do you REMEMBER all the dots?


The 2nd Power of Triangulation: REMEMBER 📐
Use what you know to remember what you forgot! For example, let's say, you can't remember "Pace Layers". But you might remember the originator "Steward Brand" ([@stewartbrand](https://twitter.com/stewartbrand)). And from there, you'll remember "Pace Layers."


Triangulating to remember is how our brains naturally work. Try it out with your graph. Hover over one idea. What is it connected to? Over time, your ideas will have many links. And this is how we build powerful and personal Knowledge Networks.


When you know two points, you can better remember a third point. Once you have a bunch of dots on your Map, you can REMEMBER things rapidly. But how do you create with the stuff you know?


The 3rd Power of Triangulation: IMAGINE 📐
Use what you know to imagine new insights! This is the radical power of linking your thinking. By building your connective thinking muscle you become a creative machine.


Now at the random crossroads between ideas, you are generating INSIGHTS! That means new forms of value. You are imagining worlds, products, and services. When you know two points, you can better imagine the third point.


These are the 3 triangulation powers to help think better than ever before! 1. Use what you know to make sense of stuff 2. Use what you know to remember old stuff 3. Use what you know to create new stuff The better you triangulate, the faster you can move in the world of ideas!


For more graphics, insights, and commentary on the 3 powers of triangulation, check out this 6-minute video: [youtu.be/JV_7nppxv7A](https://t.co/giVpsK9Ku1)


By the way, some of these graphics came from one of [@ProfFeynman](https://twitter.com/ProfFeynman)'s more hidden lectures called "Tips on Physics": [https://feynmanlectures.caltech.edu/TIPS_01.html](https://t.co/eC0MDjvZWW)





# Newsletter copy
## Sensemaking happens by Triangulation

“Triangulation” is using two known points to find a third point. Triangulating is how we make sense of the world.

Triangulation is why we love to link our thoughts.

It’s how we do our best thinking!

The better you triangulate, the faster you can move in the world of ideas.

We might as we see how it works, right?

Here’s my video on Triangulation:

[![](https://functions-js.convertkit.com/playbutton?play=%23FFFFFF&accent=%235dbcd2&thumbnailof=https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DJV_7nppxv7A&width=480&height=270&fit=contain)](https://www.youtube.com/watch?v=JV_7nppxv7A)

Hint: The last power is what **Idea Emergence** looks like.

I posted [a Twitter thread about triangulation](https://twitter.com/NickMilo/status/1550144971948232709?s=20&t=Qb1ekZ-OqUAK2FkmfQoBOw) too. It’s similar, but makes other points.

(If you watch and read both, which version do you prefer?)

Triangles are good.

Because when you have a bunch of points.

And you connect them into tons of triangles.

Guess what?

You have an **Ideaverse**.


# Scratchpad
- [[Triangulation]] - plenty I haven't covered above for the sake of brevity
- [[Spatial Context]] - haven't mentioned, out of space
- [[Method of Loci]] - haven't mentioned, out of space
- (Naturally leads to the next lesson, which covers 🥾Stronger tethers, Better Recall)
- Reminders & Insights & Triangulation: What Idea Emergence gives us (Unit 6) - Triangulation (Feynman)

---

> “I didn't have time to write a short letter, so I wrote a long one instead.” - Mark Twain

When it comes to "triangulation", I could write a really long letter. ✉️ But for the workshop, I want to honor your valuable attention, so here is the short version...


---
> Many of the best ideas are the ones we've already had—we just need the reminder.

%% Don't like this here
This is also known as the "You just finished reading a self-help book, please don't immediately read another one" Rule. I say that with great love for personal development. I also say that as someone who read way too many books regurgitating the same concepts again and again. An occasional book every once in a while? Definitely. But if you're reading it because you think you don't already know how to set goals, then you might just be procrastinating. That's because there is a truth we don't honor in an aggressively productive society. Let's say it in different ways:

>You already know what you need to know. You just need to do it.

%%

---

- We approach what we don't know through the lens of what we do know. 
- We approach the unknown through the lens of the known. 

---

### Example Alt Long
Whether it's a forum post, youtube video, or Amazon review, why do we feel compelled to read the comments? Why is watching gamers comment about their gaming a multi-billion dollar industry? Because by consuming both the THING and the comments about the THING, we're making deeper sense of the THING (along with the person commenting about the THING). 

In a world drowning in information overload, we crave quality curation.


